<?php

/*
=====================================================
    author : Adeel
    Date   : 2013/4/20
    Description : 
=====================================================
*/

if ( ! defined('EXT'))
{
    exit('Invalid file request');
}

require_once(PATH_THIRD . 'seo/model/base.php');
class Seo_MetaTags extends Seo_Base{
    protected $router = '';
    
    function Seo_MetaTags()
    {
        parent::__construct();
    }
    
    private function make_tag($title, $description){
        $tag = "<title>{$title}</title>\r\n";
        $tag .= "<meta name=\"description\" content=\"{$description}\">";
        
        return $tag;
    }
    
    function return_meta_tags(){
        $this->seo_helper->matches();
        $this->router = $this->seo_helper->get_router();
        
        switch($this->router){
            case Seo_Helper::SYSTEM:
                if($this->EE->uri->uri_string == "system/not_found_page"){
                    return $this->trigger_router_NOTFOUND();
                }
                break;
            break;
            case Seo_Helper::HOME:
                return $this->trigger_router_HOME();
            break;
            case Seo_Helper::DETAILS:
                return $this->trigger_router_DETAILS();
            break;
            case Seo_Helper::ACCOUNT_ORG_DETAIL:
                return $this->trigger_router_ACCOUNT_ORG_DETAIL();
            break;
            case Seo_Helper::ACCOUNT_VENUE_DETAIL:
                return $this->trigger_router_ACCOUNT_VENUE_DETAIL();
            break;
            case Seo_Helper::ACCOUNT_EXHIBITOR_DETAIL:
                return $this->trigger_router_ACCOUNT_EXHIBITOR_DETAIL();
            break;
            case Seo_Helper::EXPRESS_EDIT_OPTION:
                return $this->trigger_router_EXPRESS_EDIT_OPTION();
            break;
            case Seo_Helper::SPEAKER_PROFILE:
                return $this->trigger_router_SPEAKER_PROFILE();
            break;
            case Seo_Helper::BLOGS:
                return $this->trigger_router_BLOGS();
            break;
            default:
                return $this->trigger_router_NOTFOUND();
            break;
        }
    }
    
    /// triggers for routers ///
    function trigger_router_HOME(){
        $title = "Dentevents Global Dental Education and Events Calendar";
        $description = "Dentevents gives you the online event ticketing solution you need for every type of dental event and education program including conferences, exhibitions, congresses, lectures, hands-on workshops and webinars. Dentevents combines a calendar and marketing service with ticketing and delegate management tools.";
        return $this->make_tag($title, $description);
    }
    
    function trigger_router_DETAILS(){
        $name = $GLOBALS['meta']['name'];
        $country = $GLOBALS['meta']['country'];
        
        $title = "{$name}";
        $description = "{$name} - {$country}";

        return $this->make_tag($title, $description);
    }
    function trigger_router_ACCOUNT_ORG_DETAIL(){
        $practice_name = $GLOBALS['meta']['practice_name'];
        $city = $GLOBALS['meta']['city'];
        $state = $GLOBALS['meta']['state'];
        
        $title = "{$practice_name} in {$city}, {$state} - Australia";
        $description = "{$practice_name} is a Dentist in {$city}, {$state}. Click to view detailed information or to book an appointment with the dentists";
        
        return $this->make_tag($title, $description);
    }
    function trigger_router_ACCOUNT_VENUE_DETAIL(){
        $practice_name = $GLOBALS['meta']['practice_name'];
        $city = $GLOBALS['meta']['city'];
        $state = $GLOBALS['meta']['state'];
        
        $title = "{$practice_name} in {$city}, {$state} - Australia";
        $description = "{$practice_name} is a Dentist in {$city}, {$state}. Click to view detailed information or to book an appointment with the dentists";
        
        return $this->make_tag($title, $description);
    }
    function trigger_router_ACCOUNT_EXHIBITOR_DETAIL(){
        $practice_name = $GLOBALS['meta']['practice_name'];
        $city = $GLOBALS['meta']['city'];
        $state = $GLOBALS['meta']['state'];
        
        $title = "{$practice_name} in {$city}, {$state} - Australia";
        $description = "{$practice_name} is a Dentist in {$city}, {$state}. Click to view detailed information or to book an appointment with the dentists";
        
        return $this->make_tag($title, $description);
    }
    function trigger_router_EXPRESS_EDIT_OPTION(){
        $name = $GLOBALS['meta']['name'];
        $city = $GLOBALS['meta']['city'];
        $state = $GLOBALS['meta']['state'];
        
        $title = "{$name} in {$city}, {$state} - Australia";
        $description = "{$name} - {$country}";
        
        return $this->make_tag($title, $description);
    }
    function trigger_router_SPEAKER_PROFILE(){
        $name = $GLOBALS['meta']['name'];
        
        $title = "{$name}";
        $description = "{$name}";
        
        return $this->make_tag($title, $description);
    }
    function trigger_router_BLOGS(){
        $uri = $this->EE->uri->uri_string;
        
        switch($uri){
            case "about-us":
                $title = "About Us";
                $description = "About Us";
            break;
            case "contact-us":
                $title = "Contact us";
                $description = "Contact us";
            break;
            case "information-for-dentists":
                $title = "How to participate in our find a dentist service | Your Dentist™";
                $description = "Information for dentists on how to claim their free listing on Your Dentist.";
            break;
            case "useful-links":
                $title = "Useful links";
                $description = "Useful links";
            break;
            case "sitemap":
                $title = "Sitemap";
                $description = "sitemap";
            break;
            case "advertise":
                $title = "Advertise";
                $description = "advertise";
            break;
        }
       
        return $this->make_tag($title, $description);
    }
    
    function trigger_router_NOTFOUND(){
        $uri = "system/not_found_page";
        
        return $this->make_tag('404 Not Found', "Page description");
    }
    ////////////////////////////
}