<?php

/*
=====================================================
    author : Adeel
    Date   : 2013/4/20
    Description : 
=====================================================
*/

if ( ! defined('EXT'))
{
    exit('Invalid file request');
}


class Sitemap {
    protected $EE='';

    function Sitemap()
    {
        // Make a local reference to the ExpressionEngine super object
        $this->EE =& get_instance();
    }
   
    function generate_sitemap($targets){
        $path = BASE_WEB_PATH;
        $filename = "sitemap.xml";
        
        $io = $this->EE->file;
        
        $io->setAllowCreateFolders(true);
        $io->open(array('path' => $path));

        if ($io->fileExists($filename) && !$io->isWriteable($filename)) {
            $message = sprintf('File "%s" cannot be saved. Please, make sure the directory "%s" is writeable by web server.', $filename, $path);
            echo $message; exit;
        }

        $io->streamOpen($filename);
        
        $io->streamWrite('<?xml version="1.0" encoding="UTF-8"?>' . "\n");
        $io->streamWrite('<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">');

        foreach($targets as $target){
            $xml = '';
            switch($target){
                case Seo_Helper::SITEMAP_EVENTS:
                    require_once(PATH_THIRD . 'sitemap/model/sitemap_events.php');
                    $sitemap = new Sitemap_Events();
                    $sitemap->generateXML();  
                break;
            }
        }
        
        $io->streamWrite('</urlset>');
        $io->streamClose();
        
        echo "Sitemap.xml was built successfully";
    }

    
}