<?php

/*
=====================================================
    author : Adeel
    Date   : 2013/4/20
    Description :
=====================================================
*/

if ( ! defined('EXT'))
{
    exit('Invalid file request');
}

require_once(PATH_THIRD . 'sitemap/model/base.php');

class Sitemap_Events extends Sitemap_Base{
    protected $router = '';

    function Sitemap_Dentist()
    {
        parent::__construct();
    }

    public function generateXML(){
        $io = $this->EE->file;

        /// fetch events ///
        $params = array();
        $params['selects'] = "{#m}.id,{#c}.sef_url_c";
        //$params['where'] = "{#m}.event_status='Approved_Online' and ({#c}.rec_type_c NOT IN('Session','Day','Break','Stream') or {#c}.rec_type_c is null) and (({#m}.event_format IN ('Webinar','OnlineLearning') and {#c}.dentevents_tv_content_status_c <> 'Library') or {#m}.event_format NOT IN ('Webinar','OnlineLearning'))";
        $params['where'] = "{#m}.event_status='Approved_Online' and {#c}.sef_url_c is not null";
        $params['orders'] = "{#m}.start_date asc";
        $_events = $this->EE->cpd_events->get_main_data($params);

        //////////////////////
        $changefreq = "weekly";
        $priority = "0.5";

        $date = date("Y-m-d");
        foreach($_events as $item){
            $url = $item['sef_url_c'];
            if ($url == '') {
                continue;
            }
            $xml = sprintf('<url><loc>%s</loc><lastmod>%s</lastmod><changefreq>%s</changefreq><priority>%.1f</priority></url>',
                htmlspecialchars($url),
                $date,
                $changefreq,
                $priority
            );
            $io->streamWrite($xml);
        }
    }
}