[![Minimum PHP Version](https://img.shields.io/badge/php-%3E%3D%205.3-8892BF.svg)](https://php.net/)
[![Build Status](https://travis-ci.org/sugarcrm/rest-php-client.svg?branch=master)](https://travis-ci.org/sugarcrm/rest-php-client)
[![Latest Stable Version](https://poser.pugx.org/sugarcrm/rest-php-client/v/stable)](https://packagist.org/packages/sugarcrm/rest-php-client)
[![License](https://poser.pugx.org/sugarcrm/rest-php-client/license)](https://packagist.org/packages/sugarcrm/rest-php-client)
[![Total Downloads](https://poser.pugx.org/sugarcrm/rest-php-client/downloads)](https://packagist.org/packages/sugarcrm/rest-php-client)

# SugarCRM REST PHP Client

## Overview
A simple and intuitive Library for accessing a Sugar 7's REST v10 API. Allows for Object Oriented design around accessing data from a SugarCRM system, so you can easily get your integration project underway.

## Usage
Add to any project using composer:
```
"require": {
    "sugarcrm/rest-php-client": "~2.0"
}
```
> If you were previously using v1.x, please note v2.x uses different namespaces and is not backwards compatible. 
> You can run v1.x and v2.x side-by-side by using the sugarcrm/php-rest-client-v2 package, which will always maintain the latest 2.x package

__Check out the [Wiki](https://github.com/sugarcrm/rest-php-client/wiki)__ for detailed information on 
* Installation
* Usage
* Customization
* Included endpoints
* Architecture overview

## Developing the PHP REST Client

#### Requirements:
* v1.x
  * [php 5.3 - 5.6](https://php.org/)
* v2.x
  * [php 5.3+]

#### Steps:
1. With PHP installed, navigate to the repo folder (rest-php-client) via terminal.
2. Run 'composer install'

### Contributing:
See [CONTRIBUTING](CONTRIBUTING.md) for how you can contribute changes back into this project.


